USE [Elerium]
GO

/****** Object:  StoredProcedure [dbo].[RP_GenerateMonthlyBudget]    Script Date: 10/30/2013 12:29:04 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO


-- =============================================
-- Author:		<James Davis>
-- Create date: <2013-07-24>
-- Description:	<Calculates the Estimated budget at the begining of each month>
-- =============================================
ALTER PROCEDURE [dbo].[RP_GenerateMonthlyBudget]

AS
DECLARE @begingOfMonth date, @oneMonthAgoActualBudget money, @twoMonthsAgoActualBudget money, @estimatedPremiumBudget money, @estimatedPremiumBudgetTrendModifier money,
	    @ecpmDownloads int, @ecpmImpressionsModifier money, @ecpmRevenueModifier money, @ecpmBudgetShareModifier money, @ecpmBudget money,
		@PointExchangeRate money, @firstDayOflastMonth date
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	-- SET XACT_ABORT ON will cause the transaction to be uncommittable when the constraint violation occurs. 
	SET XACT_ABORT ON;
	SET NOCOUNT ON;
	-- get the first day of the month, this will work any day of the month
	SELECT @begingOfMonth = CONVERT(date, DATEADD(dd, -(DAY(GETUTCDATE()) -1), GETUTCDATE()), 101);
	-- check to see if the monthly budget exist for the current month, if it does return with success.
	IF (SELECT MonthlyBudgetDate FROM [dbo].[RewardMonthlyBudget] WHERE MonthlyBudgetDate = @begingOfMonth) IS NULL
	BEGIN
		-- CalculateEstimatedMonthlyBudget
		SELECT @estimatedPremiumBudgetTrendModifier = (SELECT EstimatedPremiumBudgetTrendModifier FROM [dbo].[RewardsProgram]);

		-- if not null get the past two actual monthly budgets
		IF (SELECT PremiumBudget FROM [dbo].[RewardMonthlyBudget] WHERE MonthlyBudgetDate = DATEADD(mm, -1, @begingOfMonth)) IS NULL
			SELECT @oneMonthAgoActualBudget = 1.0;
		ELSE
			SELECT @oneMonthAgoActualBudget = (SELECT PremiumBudget FROM [dbo].[RewardMonthlyBudget] WHERE MonthlyBudgetDate = DATEADD(mm, -1, @begingOfMonth));

		IF (SELECT PremiumBudget FROM [dbo].[RewardMonthlyBudget] WHERE MonthlyBudgetDate = DATEADD(mm, -2, @begingOfMonth)) IS NULL
			SELECT @twoMonthsAgoActualBudget = 1.0;
		ELSE
			SELECT @twoMonthsAgoActualBudget = (SELECT PremiumBudget FROM [dbo].[RewardMonthlyBudget] WHERE MonthlyBudgetDate = DATEADD(mm, -2, @begingOfMonth));

		-- if both past two actual monthly budgets where not nulll and did not get the default value of 1.0
		-- then take times the two months ago budget by the previou divided by 2 month ago raised to the power of trend modifier
		IF (@oneMonthAgoActualBudget > 1.0 and @twoMonthsAgoActualBudget > 1.0)
			SELECT @estimatedPremiumBudget = @twoMonthsAgoActualBudget * (POWER ((@oneMonthAgoActualBudget / @twoMonthsAgoActualBudget), @estimatedPremiumBudgetTrendModifier)); 
		ELSE IF(@oneMonthAgoActualBudget > 1.0 and @twoMonthsAgoActualBudget <= 1.0)
			SELECT @estimatedPremiumBudget = @oneMonthAgoActualBudget;
		ELSE IF (@oneMonthAgoActualBudget <= 1.0 and @twoMonthsAgoActualBudget > 1.0)
			SELECT @estimatedPremiumBudget = @twoMonthsAgoActualBudget;
		ELSE
			SELECT @estimatedPremiumBudget = (SELECT EstimatedPremiumBudgetDefault FROM [dbo].[RewardsProgram]);

		-- CalculateEcpmBudget 
		-- get the needed values
		SELECT @firstDayOflastMonth = DATEADD(mm, -1, @begingOfMonth);
		SELECT @begingOfMonth = CONVERT(date, DATEADD(dd, -(DAY(GETUTCDATE()) -1), GETUTCDATE()), 101);
		IF (SELECT BeginDate FROM [dbo].[RewardMonthlyEcpmDownloads] WHERE BeginDate = @firstDayOflastMonth) IS NULL
			BEGIN
				EXEC [dbo].[StartAgentJobAndWait] @job = 'Elerium_EcpmDownloadSync'
			END;
		SELECT @ecpmDownloads = (SELECT UniqueCount FROM [dbo].[RewardMonthlyEcpmDownloads] WHERE BeginDate = @firstDayOflastMonth);

		SELECT @ecpmImpressionsModifier = (SELECT EcpmImpressionsModifier FROM [dbo].[RewardsProgram]);
		SELECT @ecpmBudgetShareModifier = (SELECT EcpmBudgetShareModifier FROM [dbo].[RewardsProgram]);
		SELECT @ecpmRevenueModifier = (SELECT EcpmRevenueModifier FROM [dbo].[RewardsProgram]);
		-- do the function(product it all and round it down to nearest 100th place)
		SELECT @ecpmBudget = ROUND((@ecpmDownloads * @ecpmImpressionsModifier * @ecpmRevenueModifier * @ecpmBudgetShareModifier), 2, 1);

		-- get @PointExchangeRate
		SELECT @PointExchangeRate = (SELECT PointExchangeRate FROM [dbo].[RewardsProgram]);

		-- save row
		BEGIN TRY
	BEGIN TRANSACTION MonthlyBudget WITH MARK;  --- put all update inserts between the TRANSACTION Begin and COMMIT with XACT_ABORT ON so If one fails they all do not commit
		INSERT INTO [dbo].[RewardMonthlyBudget] 
			(MonthlyBudgetDate
			,DateCreated
			,DateModified
			,EstimatedPremiumBudget
			,EcpmBudget
			,EcpmDownloads
			,EcpmImpressionsModifier
			,EcpmRevenueModifier
			,EcpmBudgetShareModifier
			,PointExchangeRate) 
		VALUES 
			(@begingOfMonth
			,GETUTCDATE()
			,GETUTCDATE()
			,Round(@estimatedPremiumBudget,2,1)
			,@ecpmBudget
			,@ecpmDownloads
			,@ecpmImpressionsModifier
			,@ecpmRevenueModifier
			,@ecpmBudgetShareModifier
			,@PointExchangeRate);
	COMMIT TRANSACTION;
	END TRY
	BEGIN CATCH
		ROLLBACK TRANSACTION;
		return(900);
	END CATCH;
		RETURN(1);
	END
END


GO


